# APARA (Platform Scaffold)

Apara links end users to verified suppliers for clothing/merch sourcing — from affordable to luxury — with samples, mockups, deposits, and admin-controlled settlements.

## Quick Start

1) Install
```bash
npm i
```

2) Setup env
```bash
cp .env.example .env
# set DATABASE_URL
```

3) Prisma
```bash
npm run prisma:generate
npm run prisma:migrate
```

4) Seed (optional)
```bash
npm run seed
```

5) Run
```bash
npm run dev
```

## Routes
- `/` landing
- `/catalog`
- `/builder`
- `/sourcing`
- `/cart`
- `/checkout`
- `/admin/dashboard`
- `/supplier/dashboard`
- `/user/dashboard`

## API (starter)
- `POST /api/auth/register`
- `POST /api/auth/login`
- `POST /api/auth/logout`
- `POST /api/orders/create`

## Notes
This scaffold includes the RBAC-ready data model and core UI routes. Hook payments, uploads, and supplier matching next.
