import Link from "next/link";

export default function HomePage() {
  return (
    <div className="min-h-screen bg-white">
      <header className="mx-auto max-w-6xl px-4 py-6 flex items-center justify-between">
        <div className="text-xl font-semibold tracking-tight">APARA</div>
        <nav className="flex gap-4 text-sm text-neutral-700">
          <Link className="hover:text-black" href="/catalog">Catalog</Link>
          <Link className="hover:text-black" href="/sourcing">Source Item</Link>
          <Link className="hover:text-black" href="/login">Login</Link>
        </nav>
      </header>

      <main className="mx-auto max-w-6xl px-4 py-12">
        <div className="rounded-3xl border border-neutral-200 p-8 shadow-sm">
          <h1 className="text-4xl md:text-5xl leading-tight font-semibold tracking-tight">
            Build your clothing brand — or order for your event/business — without supplier stress.
          </h1>
          <p className="mt-4 text-base text-neutral-600 max-w-2xl">
            Pick items, tier (affordable → luxury), branding method, and order samples before you commit.
            If it’s not listed, we source it.
          </p>

          <div className="mt-8 grid grid-cols-1 md:grid-cols-2 gap-4">
            <Link
              href="/builder"
              className="rounded-2xl bg-black text-white p-6 hover:opacity-90 transition"
            >
              <div className="text-lg font-semibold">Start a Brand</div>
              <div className="mt-2 text-sm opacity-80">
                Save a brand profile, choose items, request samples, then bulk.
              </div>
            </Link>

            <Link
              href="/catalog"
              className="rounded-2xl border border-neutral-200 p-6 hover:bg-neutral-50 transition"
            >
              <div className="text-lg font-semibold">Order for Event / Business</div>
              <div className="mt-2 text-sm text-neutral-600">
                Baby shower, funeral, uniforms, golfers, merch.
              </div>
            </Link>
          </div>

          <div className="mt-8 grid grid-cols-2 md:grid-cols-4 gap-3 text-xs text-neutral-600">
            <div className="rounded-xl border border-neutral-200 p-3">Samples available</div>
            <div className="rounded-xl border border-neutral-200 p-3">MOQ rules</div>
            <div className="rounded-xl border border-neutral-200 p-3">Tier pricing</div>
            <div className="rounded-xl border border-neutral-200 p-3">Sourcing on demand</div>
          </div>
        </div>
      </main>

      <footer className="mx-auto max-w-6xl px-4 pb-10 text-xs text-neutral-500">
        © {new Date().getFullYear()} APARA
      </footer>
    </div>
  );
}
