import Link from "next/link";

export default function AdminDashboard() {
  return (
    <div className="mx-auto max-w-6xl px-4 py-10">
      <div className="flex items-center justify-between">
        <h2 className="text-2xl font-semibold tracking-tight">Super Admin</h2>
        <Link className="text-sm hover:underline" href="/">Home</Link>
      </div>
      <div className="mt-6 grid grid-cols-1 md:grid-cols-3 gap-4">
        {["Orders","Suppliers","Catalog","Sourcing","Payments & Settlements","Disputes","Pricing Rules","Reports","Settings"].map(x=>(
          <div key={x} className="rounded-2xl border border-neutral-200 p-5">
            <div className="font-semibold">{x}</div>
            <div className="mt-1 text-sm text-neutral-600">Route placeholder.</div>
          </div>
        ))}
      </div>
    </div>
  );
}
