import Link from "next/link";

export default function BuilderPage() {
  return (
    <div className="mx-auto max-w-5xl px-4 py-10">
      <div className="flex items-center justify-between">
        <div>
          <h2 className="text-2xl font-semibold tracking-tight">Brand Builder</h2>
          <p className="mt-1 text-sm text-neutral-600">
            Wizard: Brand → Items → Tier → Branding → Upload Art → Samples → Bulk → Checkout
          </p>
        </div>
        <Link className="text-sm hover:underline" href="/">Home</Link>
      </div>

      <div className="mt-6 grid grid-cols-1 md:grid-cols-2 gap-4">
        <div className="rounded-2xl border border-neutral-200 p-6">
          <div className="font-semibold">Step 1: Brand profile</div>
          <p className="mt-2 text-sm text-neutral-600">Name, colors, logo, packaging, neck tags.</p>
        </div>
        <div className="rounded-2xl border border-neutral-200 p-6">
          <div className="font-semibold">Step 2: Items + tier</div>
          <p className="mt-2 text-sm text-neutral-600">Select products and pick budget → luxury tier.</p>
        </div>
        <div className="rounded-2xl border border-neutral-200 p-6">
          <div className="font-semibold">Step 3: Artwork + mockup</div>
          <p className="mt-2 text-sm text-neutral-600">Upload artwork; supplier uploads mockup; user approves.</p>
        </div>
        <div className="rounded-2xl border border-neutral-200 p-6">
          <div className="font-semibold">Step 4: Samples then bulk</div>
          <p className="mt-2 text-sm text-neutral-600">Order sample; credit to bulk within a window.</p>
        </div>
      </div>

      <div className="mt-6 rounded-2xl border border-neutral-200 p-6 text-sm text-neutral-700">
        Wire-up: POST /api/builder/brand-profile, POST /api/cart/add, POST /api/orders/create
      </div>
    </div>
  );
}
