import Link from "next/link";

export default function CartPage() {
  return (
    <div className="mx-auto max-w-5xl px-4 py-10">
      <div className="flex items-center justify-between">
        <div>
          <h2 className="text-2xl font-semibold tracking-tight">Cart</h2>
          <p className="mt-1 text-sm text-neutral-600">Cart-like ordering (samples toggle per item).</p>
        </div>
        <div className="flex gap-3 text-sm">
          <Link className="hover:underline" href="/catalog">Add Items</Link>
          <Link className="hover:underline" href="/checkout">Checkout</Link>
        </div>
      </div>

      <div className="mt-6 rounded-2xl border border-neutral-200 p-6 text-sm text-neutral-700">
        Wire-up: GET /api/cart, POST /api/cart/add, POST /api/cart/remove
      </div>
    </div>
  );
}
