import Link from "next/link";

const categories = [
  { slug: "t-shirts", name: "T-Shirts" },
  { slug: "hoodies", name: "Hoodies" },
  { slug: "golfers", name: "Golfers (Polo)" },
  { slug: "chinos", name: "Chinos" },
  { slug: "tote-bags", name: "Tote Bags" },
  { slug: "sweaters", name: "Sweaters" }
];

export default function CatalogPage() {
  return (
    <div className="mx-auto max-w-6xl px-4 py-10">
      <div className="flex items-end justify-between gap-4">
        <div>
          <h2 className="text-2xl font-semibold tracking-tight">Catalog</h2>
          <p className="mt-1 text-sm text-neutral-600">Browse categories. Admin can enable/disable categories.</p>
        </div>
        <Link className="text-sm hover:underline" href="/">Home</Link>
      </div>

      <div className="mt-6 grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4">
        {categories.map(c => (
          <Link key={c.slug} href={`/catalog/${c.slug}`} className="rounded-2xl border border-neutral-200 p-5 hover:bg-neutral-50">
            <div className="text-lg font-semibold">{c.name}</div>
            <div className="mt-1 text-sm text-neutral-600">View products →</div>
          </Link>
        ))}
      </div>
    </div>
  );
}
