import Link from "next/link";

export default function CheckoutPage() {
  return (
    <div className="mx-auto max-w-5xl px-4 py-10">
      <div className="flex items-center justify-between">
        <div>
          <h2 className="text-2xl font-semibold tracking-tight">Checkout</h2>
          <p className="mt-1 text-sm text-neutral-600">Pay minimum deposit or pay in full. BWP (Pula/Thebe).</p>
        </div>
        <Link className="text-sm hover:underline" href="/cart">Back to Cart</Link>
      </div>

      <div className="mt-6 rounded-2xl border border-neutral-200 p-6 text-sm text-neutral-700">
        Wire-up: POST /api/orders/create → POST /api/payments/intent → webhook updates.
      </div>
    </div>
  );
}
