import "./globals.css";
import { ABeeZee } from "next/font/google";

const abeezee = ABeeZee({ subsets: ["latin"], weight: ["400"] });

export const metadata = {
  title: "APARA",
  description: "Build your clothing brand — or order for events/business — without supplier stress."
};

export default function RootLayout({ children }: { children: React.ReactNode }) {
  return (
    <html lang="en">
      <body className={abeezee.className + " bg-white text-neutral-900"}>{children}</body>
    </html>
  );
}
