import Link from "next/link";

export default function SourcingPage() {
  return (
    <div className="mx-auto max-w-5xl px-4 py-10">
      <div className="flex items-center justify-between">
        <div>
          <h2 className="text-2xl font-semibold tracking-tight">Source an Item</h2>
          <p className="mt-1 text-sm text-neutral-600">If it’s not in the catalog, submit a sourcing request and we’ll find it.</p>
        </div>
        <Link className="text-sm hover:underline" href="/">Home</Link>
      </div>

      <div className="mt-6 rounded-2xl border border-neutral-200 p-6 text-sm text-neutral-700">
        Wire-up: POST /api/sourcing/create, suppliers bid in Supplier Dashboard.
      </div>
    </div>
  );
}
