import Link from "next/link";

export default function SupplierDashboard() {
  return (
    <div className="mx-auto max-w-6xl px-4 py-10">
      <div className="flex items-center justify-between">
        <h2 className="text-2xl font-semibold tracking-tight">Supplier Dashboard</h2>
        <Link className="text-sm hover:underline" href="/">Home</Link>
      </div>
      <div className="mt-6 rounded-2xl border border-neutral-200 p-6 text-sm text-neutral-700">
        Orders (masked customer info until accepted), Products, Capabilities, Samples, Payouts.
      </div>
    </div>
  );
}
