import Link from "next/link";

export default function UserDashboard() {
  return (
    <div className="mx-auto max-w-6xl px-4 py-10">
      <div className="flex items-center justify-between">
        <h2 className="text-2xl font-semibold tracking-tight">My Dashboard</h2>
        <Link className="text-sm hover:underline" href="/">Home</Link>
      </div>
      <div className="mt-6 grid grid-cols-1 md:grid-cols-2 gap-4">
        <div className="rounded-2xl border border-neutral-200 p-6">
          <div className="font-semibold">My Orders</div>
          <p className="mt-1 text-sm text-neutral-600">Track production, approve mockups, download invoices.</p>
        </div>
        <div className="rounded-2xl border border-neutral-200 p-6">
          <div className="font-semibold">My Brands</div>
          <p className="mt-1 text-sm text-neutral-600">Saved brand profiles for fast reorders.</p>
        </div>
      </div>
    </div>
  );
}
