import { cookies } from "next/headers";
import { prisma } from "@/lib/db/prisma";

export async function getSessionUser(_req?: any) {
  // Simple cookie session (demo). Replace with real auth.
  const c = cookies().get("apara_uid")?.value;
  if (!c) return null;
  const user = await prisma.user.findUnique({ where: { id: c } });
  if (!user || !user.isActive) return null;
  return { id: user.id, role: user.role, email: user.email };
}
