export type Tier = "budget" | "standard" | "premium" | "luxury";

export type PricingInput = {
  baseCost: number;
  quantity: number;
  marginPct: number;
  brandingCost?: number;
  packagingCost?: number;
  deliveryCost?: number;
  platformFeePct?: number;
  rushFeePct?: number;
  rush?: boolean;
};

export function computePrice(i: PricingInput) {
  const lineBase = i.baseCost * i.quantity;
  const margin = (lineBase * i.marginPct) / 100;

  const branding = i.brandingCost ?? 0;
  const packaging = i.packagingCost ?? 0;
  const delivery = i.deliveryCost ?? 0;

  const rushFee = i.rush ? ((lineBase + margin) * (i.rushFeePct ?? 0)) / 100 : 0;
  const subtotal = lineBase + margin;

  const platformFee = ((subtotal + branding + packaging + delivery + rushFee) * (i.platformFeePct ?? 0)) / 100;
  const total = subtotal + branding + packaging + delivery + rushFee + platformFee;

  return { lineBase, margin, branding, packaging, delivery, rushFee, platformFee, total };
}
