import { prisma } from "@/lib/db/prisma";
import { hashPassword } from "@/lib/auth/password";

async function main() {
  const adminEmail = "admin@apara.local";
  const supplierEmail = "supplier@apara.local";
  const userEmail = "user@apara.local";

  const admin = await prisma.user.upsert({
    where: { email: adminEmail },
    update: {},
    create: { email: adminEmail, role: "super_admin", passwordHash: await hashPassword("AdminPass123!") }
  });

  const supplierUser = await prisma.user.upsert({
    where: { email: supplierEmail },
    update: {},
    create: { email: supplierEmail, role: "supplier_admin", passwordHash: await hashPassword("SupplierPass123!") }
  });

  const user = await prisma.user.upsert({
    where: { email: userEmail },
    update: {},
    create: { email: userEmail, role: "end_user_personal", passwordHash: await hashPassword("UserPass123!") }
  });

  const supplier = await prisma.supplier.upsert({
    where: { id: "00000000-0000-0000-0000-000000000001" },
    update: { status: "active" },
    create: { id: "00000000-0000-0000-0000-000000000001", name: "Demo Supplier", status: "active" }
  });

  await prisma.supplierUser.upsert({
    where: { userId: supplierUser.id },
    update: {},
    create: { userId: supplierUser.id, supplierId: supplier.id, role: "supplier_admin" }
  });

  const cat = await prisma.category.upsert({
    where: { slug: "hoodies" },
    update: {},
    create: { slug: "hoodies", name: "Hoodies", isEnabled: true }
  });

  await prisma.product.createMany({
    data: [
      {
        supplierId: supplier.id,
        categoryId: cat.id,
        status: "active",
        tier: "standard",
        name: "Blank Hoodie (Standard)",
        description: "Warm fleece hoodie suitable for printing/embroidery.",
        baseCost: 180,
        currency: "BWP",
        moq: 10,
        leadTimeDays: 10,
        sampleAvailable: true,
        sampleCost: 220
      }
    ],
    skipDuplicates: true
  });

  // default settings
  await prisma.platformSetting.upsert({
    where: { key: "pricing" },
    update: {},
    create: { key: "pricing", value: { default_margin_pct: 15, tier_margins: { budget: 10, standard: 15, premium: 20, luxury: 25 }, rush_fee_pct: 10 } }
  });

  await prisma.platformSetting.upsert({
    where: { key: "samples" },
    update: {},
    create: { key: "samples", value: { credit_sample_to_bulk: true, credit_window_days: 30 } }
  });

  console.log("Seeded:", { admin: admin.email, supplier: supplierUser.email, user: user.email });
}

main()
  .catch((e) => {
    console.error(e);
    process.exit(1);
  })
  .finally(async () => {
    await prisma.$disconnect();
  });
